/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.PlayerData;

public class CmdPlayers
extends CommandNoppesBase {
    @Override
    public int func_82362_a() {
        return 2;
    }

    @CommandNoppesBase.SubCommand(desc="Change the player's virtual currency balance", usage="<playername> <value>", permission=2)
    public void addmoney(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean isOnline;
        Object[] objs = this.getPlayerData(server, sender, args[0]);
        PlayerData playerdata = (PlayerData)objs[0];
        boolean bl = isOnline = objs[1] != null;
        if (playerdata == null) {
            throw new PlayerNotFoundException("commands.generic.player.notFound", new Object[]{args[0]});
        }
        try {
            long money = Long.parseLong(args[1]);
            playerdata.game.addMoney(money);
            sender.func_145747_a(new TextComponentTranslation("command.player." + (money >= 0L ? "add" : "del") + "money", new Object[]{playerdata.playername, "" + money, "" + playerdata.game.getMoney(), CustomNpcs.displayCurrencies}).func_150257_a((ITextComponent)new TextComponentTranslation(isOnline ? "gui.online" : "gui.offline", new Object[0])));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public String getDescription() {
        return "Player mod data";
    }

    @CommandNoppesBase.SubCommand(desc="Shows the player's virtual currency balance", usage="<playername>", permission=2)
    public void getmoney(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean isOnline;
        Object[] objs = this.getPlayerData(server, sender, args[0]);
        PlayerData playerdata = (PlayerData)objs[0];
        boolean bl = isOnline = objs[1] != null;
        if (playerdata == null) {
            throw new PlayerNotFoundException("commands.generic.player.notFound", new Object[]{args[0]});
        }
        sender.func_145747_a(new TextComponentTranslation("command.player.getmoney", new Object[]{playerdata.playername, "" + playerdata.game.getMoney(), CustomNpcs.displayCurrencies}).func_150257_a((ITextComponent)new TextComponentTranslation(isOnline ? "gui.online" : "gui.offline", new Object[0])));
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "player";
    }

    private Object[] getPlayerData(MinecraftServer server, ICommandSender sender, String playername) {
        EntityPlayerMP player = null;
        try {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)playername);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        PlayerData playerdata = player != null ? PlayerData.get((EntityPlayer)player) : PlayerDataController.instance.getDataFromUsername(server, playername);
        return new Object[]{playerdata, player};
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList();
        if (args.length == 2) {
            list = PlayerDataController.instance.getPlayerNames();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("openmarcet")) {
            for (int id : MarcetController.getInstance().markets.keySet()) {
                list.add("" + id);
            }
        }
        return list;
    }

    @CommandNoppesBase.SubCommand(desc="Show the store window to the player", usage="<playername> <marcetID>", permission=2)
    public void openmarcet(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int marcetId;
        EntityPlayerMP player;
        try {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        }
        catch (Exception e) {
            throw new PlayerNotFoundException("commands.generic.player.notFound", new Object[]{args[0]});
        }
        try {
            marcetId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("Must be an integer: " + args[1], new Object[0]);
        }
        Marcet marcet = (Marcet)MarcetController.getInstance().getMarcet(marcetId);
        if (marcet == null || !marcet.isValid()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.player.openmarcet.error", new Object[]{"" + marcetId}));
            return;
        }
        Server.sendDataChecked(player, EnumPacketClient.GUI, EnumGuiType.PlayerTrader.ordinal(), marcetId, 0, 0);
    }
}

